/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.common.block.IMapDisplay;
import net.mehvahdjukaar.supplementaries.common.block.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.common.block.TextHolder;
import net.mehvahdjukaar.supplementaries.common.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.common.inventories.NoticeBoardContainerMenu;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CCCompat;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1275;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1745;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3965;
import net.minecraft.class_4730;
import net.minecraft.class_5481;
import net.minecraft.class_7225;
import net.minecraft.class_9062;
import net.minecraft.class_9262;
import net.minecraft.class_9301;
import net.minecraft.class_9302;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class NoticeBoardBlockTile
extends ItemDisplayTile
implements class_1275,
IMapDisplay,
ITextHolderProvider {
    private final TextHolder textHolder;
    private boolean isWaxed = false;
    private int pageNumber = 0;
    @Nullable
    private UUID playerWhoMayEdit;
    private class_9262<String> text = null;
    private float fontScale = 1.0f;
    private List<class_5481> cachedPageLines = Collections.emptyList();
    private boolean needsVisualRefresh = true;
    private class_4730 cachedPattern = null;
    private boolean isNormalItem = false;

    public NoticeBoardBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.NOTICE_BOARD_TILE.get(), pos, state);
        this.textHolder = new TextHolder(1, 90);
    }

    public class_2561 method_17823() {
        return class_2561.method_43471((String)"gui.supplementaries.notice_board");
    }

    public void updateTileOnInventoryChanged() {
        boolean shouldHaveBook = !this.getDisplayedItem().method_7960();
        class_2680 state = this.method_11010();
        if ((Boolean)state.method_11654((class_2769)class_2741.field_17393) != shouldHaveBook) {
            this.field_11863.method_8652(this.field_11867, (class_2680)state.method_11657((class_2769)class_2741.field_17393, (Comparable)Boolean.valueOf(shouldHaveBook)), 2);
            if (shouldHaveBook) {
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_17481, class_3419.field_15245, 1.0f, this.field_11863.field_9229.method_43057() * 0.1f + 0.85f);
            } else {
                this.pageNumber = 0;
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_17481, class_3419.field_15245, 1.0f, this.field_11863.field_9229.method_43057() * 0.1f + 0.5f);
            }
        }
    }

    @Override
    public class_1799 getMapStack() {
        return this.getDisplayedItem();
    }

    public void updateClientVisualsOnLoad() {
        class_1799 itemstack = this.getDisplayedItem();
        class_1792 item = itemstack.method_7909();
        this.cachedPattern = null;
        if (item instanceof class_1745) {
            class_1745 bannerPatternItem = (class_1745)item;
            this.cachedPattern = ModMaterials.getFlagMaterialForPatternItem(this.field_11863, bannerPatternItem);
        }
        this.needsVisualRefresh = true;
        this.cachedPageLines = Collections.emptyList();
        this.text = null;
        this.updateText();
        this.isNormalItem = !NoticeBoardBlockTile.isPageItem(itemstack.method_7909());
    }

    public boolean isNormalItem() {
        return this.isNormalItem;
    }

    public void updateText() {
        this.text = null;
        class_1799 itemstack = this.getDisplayedItem();
        class_9302 written = (class_9302)itemstack.method_57824(class_9334.field_49606);
        if (written != null) {
            List pages = written.comp_2422();
            if (!pages.isEmpty()) {
                if (this.pageNumber >= pages.size()) {
                    this.pageNumber %= pages.size();
                }
                this.text = ((class_9262)pages.get(this.pageNumber)).method_57138(class_2561::getString);
            }
            return;
        }
        class_9301 writable = (class_9301)itemstack.method_57824(class_9334.field_49653);
        if (writable != null) {
            List pages = writable.comp_2422();
            if (!pages.isEmpty()) {
                if (this.pageNumber >= pages.size()) {
                    this.pageNumber %= pages.size();
                }
                this.text = (class_9262)pages.get(this.pageNumber);
            }
            return;
        }
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.pageNumber = tag.method_10550("PageNumber");
        this.textHolder.load(tag, registries, this.field_11867);
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        tag.method_10569("PageNumber", this.pageNumber);
        this.textHolder.save(tag, registries);
    }

    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return new NoticeBoardContainerMenu(id, inventory, this);
    }

    public boolean method_5437(int index, class_1799 stack) {
        return this.method_5442() && (CommonConfigs.Building.NOTICE_BOARDS_UNRESTRICTED.get() != false || NoticeBoardBlockTile.isPageItem(stack.method_7909()));
    }

    public static boolean isPageItem(class_1792 item) {
        return item.method_40131().method_40220(class_3489.field_21465) || item instanceof class_1806 || item instanceof class_1745 || CompatHandler.COMPUTERCRAFT && CCCompat.isPrintedBook(item);
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 direction) {
        return this.method_5437(index, stack);
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return true;
    }

    public boolean shouldSkipTileRenderer() {
        return (Boolean)this.method_11010().method_11654((class_2769)NoticeBoardBlock.CULLED) != false || (Boolean)this.method_11010().method_11654((class_2769)NoticeBoardBlock.HAS_BOOK) == false;
    }

    public class_4730 getCachedPattern() {
        return this.cachedPattern;
    }

    @Nullable
    public class_9262<String> getText() {
        return this.text;
    }

    public class_1767 getDyeColor() {
        return this.textHolder.getColor();
    }

    public boolean isGlowing() {
        return this.textHolder.hasGlowingText();
    }

    public boolean hasAntiqueInk() {
        return this.textHolder.supplementaries$isAntique();
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(float s) {
        this.fontScale = s;
    }

    public void setCachedPageLines(List<class_5481> l) {
        this.cachedPageLines = l;
    }

    public List<class_5481> getCachedLines() {
        return this.cachedPageLines;
    }

    public boolean needsVisualUpdate() {
        if (this.needsVisualRefresh) {
            this.needsVisualRefresh = false;
            return true;
        }
        return false;
    }

    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)NoticeBoardBlock.FACING);
    }

    public void turnPage() {
        ++this.pageNumber;
        this.field_11863.method_8396(null, this.field_11867, class_3417.field_17481, class_3419.field_15245, 1.0f, this.field_11863.field_9229.method_43057() * 0.1f + 1.45f);
        this.method_5431();
    }

    public class_9062 interact(class_1657 player, class_1268 handIn, class_2338 pos, class_2680 state, class_3965 hit, class_1799 stack) {
        class_9062 res;
        class_1937 level = player.method_37908();
        if (player.method_5715() && !this.method_5442() && player.method_5998(handIn).method_7960()) {
            class_1799 it = this.method_5441(0);
            class_2338 newPos = pos.method_10081(((class_2350)state.method_11654((class_2769)NoticeBoardBlock.FACING)).method_10163());
            class_1542 drop = new class_1542(level, (double)newPos.method_10263() + 0.5, (double)newPos.method_10264() + 0.5, (double)newPos.method_10260() + 0.5, it);
            drop.method_6988();
            level.method_8649((class_1297)drop);
            this.method_5431();
            return class_9062.method_55644((boolean)level.field_9236);
        }
        class_2350 face = hit.method_17780();
        if (face == state.method_11654((class_2769)NoticeBoardBlock.FACING) && (res = super.interactWithPlayerItem(player, handIn, stack)).method_55643()) {
            return res;
        }
        class_9062 r = this.textHolderInteract(0, level, pos, state, player, handIn, stack, face);
        if (r != class_9062.field_47731) {
            return r;
        }
        if (!CommonConfigs.Building.NOTICE_BOARD_GUI.get().booleanValue()) {
            return class_9062.field_47731;
        }
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            this.tryOpeningEditGui(sp, pos, player.method_5998(handIn), face);
        }
        return class_9062.method_55644((boolean)level.field_9236);
    }

    public void setPlayerWhoMayEdit(@Nullable UUID uuid) {
        this.playerWhoMayEdit = uuid;
    }

    public UUID getPlayerWhoMayEdit() {
        return this.playerWhoMayEdit;
    }

    @Override
    public TextHolder getTextHolder(int ind) {
        return this.textHolder;
    }

    public boolean isWaxed() {
        return this.isWaxed;
    }

    public void setWaxed(boolean b) {
        this.isWaxed = b;
    }
}

